package newchat;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Observable;
import java.util.Observer;

public class ClientController implements ActionListener, Observer, WindowListener{
	private ClientModel model;
	private ClientView view;
	
	public ClientController()
	{
		this.model = new ClientModel(this);
		this.view = new ClientView(this);
		this.view.getJFrame().setVisible(true);
	}
	@Override
	public void actionPerformed(ActionEvent e)
	{
		String cmd = e.getActionCommand();
		if(cmd.equals(this.view.getSendButton().getActionCommand()))
		{
			MessagePublic msgPub = new MessagePublic();
			//msgPub.setSender();
			msgPub.setMsg(this.view.getMessageField().getText());
			this.model.sendRequest(msgPub);
			this.view.getMessageField().setText("");
			this.view.getMessageField().requestFocus();			
		}
		else if (cmd.equals(this.view.getLoginButton().getActionCommand()))
		{
			Login login = new Login();
			//login.setSender();
			login.setUsername(this.view.getLoginField().getText());
			login.setPassword(this.view.getPwdField().getPassword());
			this.model.sendRequest(login);
		}
		else if (cmd.equals(this.view.getCancelButton().getActionCommand()))
		{
			Logout logout = new Logout();
			this.model.sendRequest(logout);
			System.exit(0);
		}
	}
	@Override
	public void update(Observable obs, Object srvmsg) 
	{
		if (!this.view.isChat())
		{
			if (((Response)srvmsg).getMessage().equals(Responses.Login_failed) 
			  ||((Response)srvmsg).getMessage().equals(Responses.not_authenticated))
			{

			}
			else
			{
				this.view.getJContentPane().remove(this.view.getLoginPanel());
				this.view.getJContentPane().add(this.view.getChatPanel());
				this.view.setChat(true);
				this.view.getJFrame().setSize(450, 300);
			}
		}
		else
		{
			this.view.getChatHistory().append((String) srvmsg +"\n");
		}
		this.view.getJFrame().repaint();	
	}
	@Override
	public void windowActivated(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void windowClosed(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override	
	public void windowClosing(WindowEvent arg0) {
		// TODO Auto-generated method stub
		Logout logout = new Logout();
		this.model.sendRequest(logout);
	}
	@Override
	public void windowDeactivated(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void windowDeiconified(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void windowIconified(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void windowOpened(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}
}
