package newchat;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;

public class ClientHandler extends Thread
{
	private Socket client;
	private RequestHandler requestHandler;
	
	public ClientHandler(Socket clnt)
	{
		this.client = clnt;
		this.requestHandler = new RequestHandler(clnt);
	}
	public void run()
	{
		try
		{
			Request request = null;
			while(true)
			{
					ObjectInputStream ois = new ObjectInputStream(client.getInputStream());
					ObjectOutputStream oos = new ObjectOutputStream(client.getOutputStream());
					oos.flush();
					request = (Request)ois.readObject();
					Response response = new Response();
					response.setMessage(requestHandler.process(request));
					System.out.println(response.getMessage());
					oos.writeObject(response);
					
			}
		}
		catch (IOException e) {
			System.err.println("Error reading request from client");
		}
		catch (ClassNotFoundException e) {
			System.err.println("Serialization error");
		}
	}
}