package newchat;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.UnknownHostException;

public class ClientModel 
{	
	@SuppressWarnings("unused")
	private ClientController cc;
	Socket server = null;
	
	public ClientModel(ClientController cc)
	{
		this.cc = cc;
        try 
        {
            this.server = new Socket(Config.host, Config.port);
        } 
        catch (UnknownHostException e) 
        {
            System.err.println("Host is not available "+Config.host);
            System.exit(1);
        } 
        catch (IOException e) 
        {
        	System.err.println("Server is not available at "+Config.host+" : "+Config.port);
            System.exit(1);
		}
        Thread sh = new Thread(new ServerHandler(server,cc));
        sh.start();
	}
	
	public void sendRequest(Request rqst)
	{
		try	
		{
			ObjectOutputStream oos = new ObjectOutputStream(server.getOutputStream());
			oos.flush();
			oos.writeObject(rqst);
		}
		catch(Exception e)
		{
			System.err.println("Error sending request");
		}
	}
}	
