package newchat;

import java.awt.Dimension;
import java.awt.Rectangle;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ScrollPaneConstants;

public class ClientView{
	private JFrame jFrame = null;  
	private JPanel jContentPane = null;
	private JButton loginButton = null;
	private JButton cancelButton = null;
	private JTextField loginField = null;
	private JPasswordField pwdField = null;
	private JLabel loginLabel = null;
	private JLabel pwdLabel = null;
	private JLabel welcomeLabel = null;
	private JPanel loginPanel = null;
	private JTextArea chatHistory = null;
	private JTextArea messageField = null; 
	private JButton sendButton = null;
	private JScrollPane scrollPane1 = null;
	private JScrollPane scrollPane2 = null;
	private JPanel chatPanel = null;
	
	private boolean isChat = false;
	public boolean isChat() {
		return isChat;
	}

	public void setChat(boolean isChat) {
		this.isChat = isChat;
	}

	/**
	 * This method initializes loginButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	public JButton getLoginButton() {
		if (loginButton == null) {
			loginButton = new JButton();
			loginButton.setText("Login");
			loginButton.setBounds(new Rectangle(278, 126, 65, 26));
			loginButton.addActionListener(cc);
		}
		return loginButton;
	}

	/**
	 * This method initializes cancelButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	public JButton getCancelButton() {
		if (cancelButton == null) {
			cancelButton = new JButton();
			cancelButton.setText("Cancel");
			cancelButton.setBounds(new Rectangle(355, 126, 79, 26));
			cancelButton.addActionListener(cc);
		}
		return cancelButton;
	}

	/**
	 * This method initializes loginField	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	public JTextField getLoginField() {
		if (loginField == null) {
			loginField = new JTextField();
			loginField.setBounds(new Rectangle(46, 126, 95, 20));
		}
		return loginField;
	}

	/**
	 * This method initializes pwdField	
	 * 	
	 * @return javax.swing.JPasswordField	
	 */
	public JPasswordField getPwdField() {
		if (pwdField == null) {
			pwdField = new JPasswordField();
			pwdField.setBounds(new Rectangle(148, 126, 111, 20));
		}
		return pwdField;
	}

	/**
	 * This method initializes loginPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	public JPanel getLoginPanel() {
		if (loginPanel == null) {
			loginPanel = new JPanel();
			loginPanel.setLayout(null);
			loginPanel.setBounds(new Rectangle(0, -1, 466, 214));
			loginPanel.add(getCancelButton(), null);
			loginPanel.add(getLoginButton(), null);
			loginPanel.add(getPwdField(), null);
			loginPanel.add(pwdLabel, null);
			loginPanel.add(getLoginField(), null);
			loginPanel.add(loginLabel, null);
			loginPanel.add(welcomeLabel, null);
		}
		return loginPanel;
	}

	/**
	 * This method initializes chatHistory	
	 * 	
	 * @return javax.swing.JTextArea	
	 */
	public JTextArea getChatHistory() {
		if (chatHistory == null) {
			chatHistory = new JTextArea();
			chatHistory.setBounds(new Rectangle(35, -4, 457, 224));
			scrollPane1 = new JScrollPane(chatHistory,
	                ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
	                ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
			scrollPane1.setBounds(new Rectangle(3, 3, 425, 224));
		}
		return chatHistory;
	}

	/**
	 * This method initializes messageField	
	 * 	
	 * @return javax.swing.JTextArea	
	 */
	public JTextArea getMessageField() {
		if (messageField == null) {
			messageField = new JTextArea();
			messageField.setBounds(new Rectangle(3, 231, 405, 135));
			scrollPane2 = new JScrollPane(messageField,
	                ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
	                ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
			scrollPane2.setBounds(new Rectangle(5, 234, 306, 38));
		}
		return messageField;
	}

	/**
	 * This method initializes sendButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	public JButton getSendButton() {
		if (sendButton == null) {
			sendButton = new JButton();
			sendButton.setText("Send");
			sendButton.setBounds(new Rectangle(315, 235, 112, 36));
			sendButton.addActionListener(cc);
		}
		return sendButton;
	}

	/**
	 * This method initializes chatPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	public JPanel getChatPanel() {
		if (chatPanel == null) {
			chatPanel = new JPanel();
			chatPanel.setLayout(null);
			chatPanel.setSize(new Dimension(434, 277));
			chatPanel.add(scrollPane2, null);
			chatPanel.add(getSendButton(), null);
			chatPanel.add(scrollPane1, null);
		}
		return chatPanel;
	}

	/**
	 * This method initializes jFrame
	 * 
	 * @return javax.swing.JFrame
	 */
	public JFrame getJFrame() {
		if (jFrame == null) {
			jFrame = new JFrame();
			jFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
			jFrame.setSize(478, 279);
			jFrame.setContentPane(getJContentPane());
			jFrame.setTitle("Chat Application");
			jFrame.addWindowListener(cc);
			jFrame.setResizable(false);
		}
		return jFrame;
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	public JPanel getJContentPane() {
		if (jContentPane == null) {
			welcomeLabel = new JLabel();
			welcomeLabel.setText("Welcome to chat!");
			welcomeLabel.setBounds(new Rectangle(164, 31, 119, 16));
			pwdLabel = new JLabel();
			pwdLabel.setText("Password:");
			pwdLabel.setBounds(new Rectangle(152, 111, 86, 16));
			loginLabel = new JLabel();
			loginLabel.setText("Login:");
			loginLabel.setBounds(new Rectangle(47, 111, 43, 16));
			jContentPane = new JPanel();
			jContentPane.setLayout(null);
			jContentPane.add(getLoginPanel(), null);
		}
		return jContentPane;
	}
   
	ClientController cc;
	
	public ClientView(ClientController cc)
	{
		this.cc = cc;
		this.chatHistory = this.getChatHistory();
		this.messageField = this.getMessageField();
	}
	
    public ClientView(Runnable runnable) {
		// TODO Auto-generated constructor stub
	}
}
