package newchat;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;

public class RequestHandler 
{
	Socket client;
	boolean authenticated;
	
	public RequestHandler(Socket cl)
	{
		client = cl;
		authenticated = false;
	}
	public String process(Request r)
	{
		if (r instanceof Login)
		{
			if(processLogin(((Login) r).getUsername()))
			{
				authenticated = true;
				return Responses.Login_ok;
			}
			else
				return Responses.Login_failed;
		}
		else 
		{
			if (authenticated)
			{
				if (r instanceof Message)
				{
					Message msg = (Message)r;
					if (msg.getType().equals("public"))
					{
						if(sendPublicMessage(msg.getMsg())) 
							return Responses.Msg_sent;
						else 
							return Responses.Msg_failed;
					}
				}
				else if (r instanceof Logout)
				{
					if(processLogout(((Logout)r).getSender()))
						return Responses.Logout_ok;
					else
						return Responses.Logout_failed;
				}
					return Responses.bad_request;
			}
			else
				return Responses.not_authenticated;
		}
	}
	private synchronized boolean sendPublicMessage(String msg)
	{
		for (Socket client: UsersSingleton.getUserTable().values())
		{
			try
			{
				ObjectOutputStream oos = new ObjectOutputStream(client.getOutputStream());
				oos.writeObject(msg);
				oos.flush();
			} 
			catch (IOException e)
			{
				System.err.println("Error writing");
				return false;
			}
		}
		return true;
	}
	public synchronized boolean processLogin(String username)
	{
		UsersSingleton.addUser(username, client);
		return true;
	}
	public synchronized boolean processLogout(String un)
	{
		return UsersSingleton.removeUser(un);
	}
}