package newchat;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.Socket;
import java.util.Observable;
import java.util.Observer;

public class ServerHandler extends Observable implements Runnable
{
	private Socket srv;
	private Observer cc;
	
	public ServerHandler(Socket srv, Observer cc)
	{
		this.cc = cc;
		this.srv = srv;
		addObserver(this.cc);
	}
	@Override
	public void run() 
	{
		try
		{
			Object srvmsg = null;
			while(true)
			{
					ObjectInputStream ois = new ObjectInputStream(srv.getInputStream());
					srvmsg = ois.readObject();
					if (srvmsg instanceof Response)
					{
						Response response = null;
						response = (Response)srvmsg;
						setChanged();
						notifyObservers(response);
						System.out.println("response");
					}
					else if (srvmsg instanceof String)
					{
						String msg = null;
						msg = (String)srvmsg;
						setChanged();
						notifyObservers(msg);
						System.out.println("string");
					}
			}
		}
		catch (IOException e)
		{
			//System.err.println("Error reading response");
			e.printStackTrace();
		}
		catch (ClassNotFoundException e)
		{
			System.err.println("Error");
		}
	}
}
