//singleton class USERS
package newchat;

import java.net.Socket;
import java.util.Hashtable;

public class UsersSingleton{
	private static UsersSingleton users;
	private static Hashtable<String, Socket> userTable = new Hashtable<String, Socket>();
	private UsersSingleton(){}
	public static UsersSingleton getUsers()
	{
		if(users==null)
		{
			users = new UsersSingleton();
		}
		return users;
	}
	public static Hashtable<String, Socket> getUserTable()
	{
		return userTable;
	}
	public static synchronized boolean addUser(String username, Socket client)
	{
		if (userTable.containsKey(username)) 
			return false;
		userTable.put(username, client);
		return true;
	}
	
	public static synchronized boolean removeUser(String un)
	{
		if(userTable.remove(un) != null)
			return true;
		return false;
	}
}
